<?php
/**
 * Additional Settings
 *
 * @package doccure
 */
return array(
    'title' => esc_html('Additional Settings', 'doccure'),
    'id' => 'additional_settings',
    'icon' => 'el el-credit-card',
    'fields' => array(
        array(
            'id' => 'cpt-filter-section-start',
            'type' => 'divide'
        ),
        array(
            'id' => 'enable-cpt-image-filter',
            'type' => 'switch',
            'title' => esc_html__('Enable CPT Image Filter', 'doccure'),
            'default' => false,
            'subtitle' => esc_html__('Enable to set image filter for all custom post type featured images.', 'doccure'),
        ),
        array(
            'id' => 'filter-style',
            'type' => 'select',
            'title' => esc_html__('Select Filter Style', 'doccure'),
            'subtitle' => esc_html__('Please select the filter style to display.', 'doccure'),
            'options' => array(
                'blur' => esc_html__('Blur', 'doccure'),
                'brightness' => esc_html__('Brightness', 'doccure'),
                'contrast' => esc_html__('Contrast', 'doccure'),
                'drop-shadow' => esc_html__('Drop Shadow', 'doccure'),
                'grayscale' => esc_html__('Grayscale', 'doccure'),
                'hue-rotate' => esc_html__('Hue Rotate', 'doccure'),
                'invert' => esc_html__('Invert', 'doccure'),
                'opacity' => esc_html__('Opacity', 'doccure'),
                'saturate' => esc_html__('Saturate', 'doccure'),
                'sepia' => esc_html__('Sepia', 'doccure'),
            ),
            'default' => '',
            'required' => array('enable-cpt-image-filter', '=', 'true'),
        ),
        array(
            'id' => 'blur_value',
            'type' => 'slider',
            'title' => esc_html__('Set Blur Value', 'doccure'),
            'subtitle' => esc_html__('Adjust blur filter value', 'doccure'),
            "min" => 0,
            "step" => .1,
            "max" => 10,
            'resolution' => 0.1,
            'required' => array('filter-style', '=', 'blur'),
        ),
        array(
            'id' => 'brightness_value',
            'type' => 'slider',
            'title' => esc_html__('Set Brightness Value', 'doccure'),
            'subtitle' => esc_html__('Adjust brightness filter value', 'doccure'),
            "min" => 0,
            "step" => .1,
            "max" => 3,
            'resolution' => 0.1,
            'required' => array('filter-style', '=', 'brightness'),
        ),
        array(
            'id' => 'contrast_value',
            'type' => 'slider',
            'title' => esc_html__('Set Contrast Value', 'doccure'),
            'subtitle' => esc_html__('Adjust contrast filter value', 'doccure'),
            "min" => 0,
            "step" => .1,
            "max" => 3,
            'resolution' => 0.1,
            'required' => array('filter-style', '=', 'contrast'),
        ),
        array(
            'id' => 'drop_shadow_offset_x_value',
            'type' => 'slider',
            'title' => esc_html__('Set Offset X Value', 'doccure'),
            'subtitle' => esc_html__('Adjust drop shadow offset x value in px', 'doccure'),
            "min" => 0,
            "step" => 1,
            "max" => 30,
            'required' => array('filter-style', '=', 'drop-shadow'),
        ),
        array(
            'id' => 'drop_shadow_offset_y_value',
            'type' => 'slider',
            'title' => esc_html__('Set Offset Y Value', 'doccure'),
            'subtitle' => esc_html__('Adjust drop shadow offset y value in px', 'doccure'),
            "min" => 0,
            "step" => 1,
            "max" => 30,
            'required' => array('filter-style', '=', 'drop-shadow'),
        ),
        array(
            'id' => 'drop_shadow_blur_value',
            'type' => 'slider',
            'title' => esc_html__('Set Drop Shadow Blur Value', 'doccure'),
            'subtitle' => esc_html__('Adjust drop shadow blur value in px', 'doccure'),
            "min" => 0,
            "step" => 1,
            "max" => 30,
            'required' => array('filter-style', '=', 'drop-shadow'),
        ),
        array(
            'id' => 'drop_shadow_color',
            'type' => 'color',
            'title' => esc_html__('Drop Shadow Color', 'doccure'),
            'subtitle' => esc_html__('Set drop shadow color.', 'doccure'),
            'transparent' => false,
            'default' => '',
            'required' => array('filter-style', '=', 'drop-shadow'),
        ),
        array(
            'id' => 'grayscale_value',
            'type' => 'slider',
            'title' => esc_html__('Set Grayscale Value', 'doccure'),
            'subtitle' => esc_html__('Adjust grayscale filter value', 'doccure'),
            "min" => 0,
            "step" => .1,
            "max" => 1,
            'resolution' => 0.1,
            'required' => array('filter-style', '=', 'grayscale'),
        ),
        array(
            'id' => 'hue_roate_value',
            'type' => 'slider',
            'title' => esc_html__('Set Hue-rotate Value', 'doccure'),
            'subtitle' => esc_html__('Adjust hue-rotate filter value', 'doccure'),
            "min" => 0,
            "step" => 1,
            "max" => 360,
            'required' => array('filter-style', '=', 'hue-rotate'),
        ),
        array(
            'id' => 'invert_value',
            'type' => 'slider',
            'title' => esc_html__('Set Invert Value', 'doccure'),
            'subtitle' => esc_html__('Adjust invert filter value', 'doccure'),
            "min" => 0,
            "step" => .1,
            "max" => 1,
            'resolution' => 0.1,
            'required' => array('filter-style', '=', 'invert'),
        ),
        array(
            'id' => 'opacity_value',
            'type' => 'slider',
            'title' => esc_html__('Set Opacity Value', 'doccure'),
            'subtitle' => esc_html__('Adjust opacity filter value', 'doccure'),
            "min" => 0,
            "step" => .1,
            "max" => 1,
            'resolution' => 0.1,
            'required' => array('filter-style', '=', 'opacity'),
        ),
        array(
            'id' => 'saturate_value',
            'type' => 'slider',
            'title' => esc_html__('Set Saturate Value', 'doccure'),
            'subtitle' => esc_html__('Adjust saturate filter value', 'doccure'),
            "min" => 0,
            "step" => .1,
            "max" => 3,
            'resolution' => 0.1,
            'required' => array('filter-style', '=', 'saturate'),
        ),
        array(
            'id' => 'sepia_value',
            'type' => 'slider',
            'title' => esc_html__('Set Sepia Value', 'doccure'),
            'subtitle' => esc_html__('Adjust sepia filter value', 'doccure'),
            "min" => 0,
            "step" => .1,
            "max" => 1,
            'resolution' => 0.1,
            'required' => array('filter-style', '=', 'sepia'),
        ),
        array(
            'id' => 'mapbox-section-start',
            'type' => 'divide'
        ),
        array(
            'id' => 'mapbox_access_token_value',
            'type' => 'textarea',
            'title' => esc_html__('Mabox Access Token', 'doccure'),
            'subtitle' => esc_html__('Please enter access token to show mapbox', 'doccure'),
        ),
        array(
            'id' => 'smooth-scroll-section-start',
            'type' => 'divide'
        ),
        array(
            'id' => 'enable-smooth-scroll',
            'type' => 'switch',
            'title' => esc_html__('Enable Smooth Scroll', 'doccure'),
            'default' => false,
        ),
        array(
            'id' => 'smooth_scroll_style',
            'type' => 'select',
            'title' => esc_html__('Select scroll effect', 'doccure'),
            'options' => array(
                'ultra_speed' => 'Yes - Ultra Fast speed(almost disabled)',
                'fast_speed' => 'Yes - Fast speed',
                'moderate_speed' => 'Yes - Moderate speed',
                'default_speed' => 'No - Disabled',
                'slow_speed' => 'Yes - Slow speed',
                'super_slow_speed' => 'Yes - Super Slow speed',
                'snail_speed' => 'Yes - Snail speed',
            ),
            'default' => 'default_speed',
            'required' => array('enable-smooth-scroll', '=', 'true'),
        ),
        array(
            'id' => 'site-search-section-start',
            'type' => 'divide'
        ),
        array(
            'id' => 'enable-ajax-search',
            'type' => 'switch',
            'title' => esc_html__('Enable ajax search for header search', 'doccure'),
            'default' => false,
        ),
        array(
            'id' => 'search-result-cpt',
            'type' => 'select',
            'multi' => true,
            'title' => esc_html__('Select CPT for search results', 'doccure'),
            'subtitle' => esc_html__('Select custom post type for which search result will return', 'doccure'),
            'data' => 'post_types'
        ),
        array(
            'id' => 'lazy-loading-section-start',
            'type' => 'divide'
        ),
        array(
            'id' => 'enable-lazy-loading',
            'type' => 'switch',
            'title' => esc_html__('Enable Lazy Loading', 'doccure'),
            'default' => false,
        ),
        array(
            'id' => 'lazy-load-thumb',
            'type' => 'media',
            'url' => true,
            'title' => esc_html__('Lazy Load Image', 'doccure'),
            'compiler' => 'true',
            'subtitle' => esc_html__('Upload custom image for lazy load', 'doccure'),
            'required' => array('enable-lazy-loading', '=', 'true'),
        ),
    ),
);
